/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.access_log.read;

import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ComplianceAwareStoredFieldVisitor;
import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ReadLogContext;
import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

public class ReadLogDirectoryReader
extends FilterDirectoryReader {
    private final ReadLogContext context;

    public ReadLogDirectoryReader(DirectoryReader in, ReadLogContext context) throws IOException {
        super(in, (FilterDirectoryReader.SubReaderWrapper)new SubReaderWrapper(context));
        this.context = context;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new ReadLogDirectoryReader(in, this.context);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private static class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ReadLogContext context;

        SubReaderWrapper(ReadLogContext context) {
            this.context = context;
        }

        public LeafReader wrap(LeafReader reader) {
            return new FilterLeafReader(reader, this.context);
        }

        private static class FilterLeafReader
        extends SequentialStoredFieldsLeafReader {
            private final ReadLogContext context;

            FilterLeafReader(LeafReader delegate, ReadLogContext context) {
                super(delegate);
                this.context = context;
            }

            protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
                return new ReadLogStoredFieldsReader(reader);
            }

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                if (this.context.getAuditLogConfig().isEnabled() && this.context.getAuditLogConfig().readHistoryEnabledForIndex(this.context.getIndex().getName())) {
                    ComplianceAwareStoredFieldVisitor complianceAwareStoredFieldVisitor = new ComplianceAwareStoredFieldVisitor(visitor, this.context);
                    this.in.document(docID, (StoredFieldVisitor)complianceAwareStoredFieldVisitor);
                    complianceAwareStoredFieldVisitor.finished();
                } else {
                    this.in.document(docID, visitor);
                }
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return this.getDelegate().getCoreCacheHelper();
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return this.getDelegate().getReaderCacheHelper();
            }

            private class ReadLogStoredFieldsReader
            extends StoredFieldsReader {
                private final StoredFieldsReader delegate;

                public ReadLogStoredFieldsReader(StoredFieldsReader delegate) {
                    this.delegate = delegate;
                }

                public void close() throws IOException {
                    this.delegate.close();
                }

                public long ramBytesUsed() {
                    return this.delegate.ramBytesUsed();
                }

                public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
                    if (FilterLeafReader.this.context.getAuditLogConfig().isEnabled() && FilterLeafReader.this.context.getAuditLogConfig().readHistoryEnabledForIndex(FilterLeafReader.this.context.getIndex().getName())) {
                        ComplianceAwareStoredFieldVisitor complianceAwareStoredFieldVisitor = new ComplianceAwareStoredFieldVisitor(visitor, FilterLeafReader.this.context);
                        this.delegate.visitDocument(docID, (StoredFieldVisitor)complianceAwareStoredFieldVisitor);
                        complianceAwareStoredFieldVisitor.finished();
                    } else {
                        this.delegate.visitDocument(docID, visitor);
                    }
                }

                public StoredFieldsReader clone() {
                    return new ReadLogStoredFieldsReader(this.delegate);
                }

                public void checkIntegrity() throws IOException {
                    this.delegate.checkIntegrity();
                }
            }
        }
    }
}

